//-------------------------------------------------
//          TestSuite: Stack Consistency
//-------------------------------------------------

#include "lcd.h"
#include "util.h"
#include "os_core.h"
#include "os_scheduler.h"

#include <avr/interrupt.h>
#include <stdint.h>

#define DELAY 100 

void dumper(uint16_t* mine, uint16_t volatile const* his, uint8_t const* dummy) {
  os_enterCriticalSection();
  *mine = (uint16_t)dummy;
  os_leaveCriticalSection();
  while (!*his);
  if (*mine < *his) {
    for (;;);
  }
  lcd_writeChar(*dummy);
  lcd_writeChar(':');
  lcd_writeChar(' ');

  unsigned i = *mine - *his - 24;
  while (++i) {
    lcd_writeDec(i);
    {
      uint8_t arr[i];
      *arr ^= 0xFF;
    }
    lcd_writeChar(';');
    lcd_writeChar(' ');
    delayMs(3*DELAY);
  }
  os_error("Consistency check broken");
}

uint16_t p1 = 0;
uint16_t p2 = 0;

PROGRAM(1, AUTOSTART) {
  uint8_t i = '1';
  dumper(&p1, &p2, &i);
}

PROGRAM(2, AUTOSTART) {
  uint8_t i = '2';
  dumper(&p2, &p1, &i);
}
